--DROP TABLE RC_DEB_CLI_PDV
IF	OBJECT_ID('RC_DEB_CLI_PDV') IS NULL
BEGIN
CREATE TABLE	RC_DEB_CLI_PDV
(
	CD_CTR		BIGINT	IDENTITY(1,1),
	CD_EMP		INT	NOT NULL,
	CD_CLI		INT	NOT NULL,
	DT_ALT		DATETIME NOT NULL DEFAULT GETDATE(),
	FAT_XML		XML NOT NULL
)

CREATE INDEX UK_RC_DEB_CLI_PDV ON RC_DEB_CLI_PDV(CD_EMP,CD_CLI) INCLUDE (CD_CTR,DT_ALT)
ALTER TABLE RC_DEB_CLI_PDV ADD CONSTRAINT PK_RC_DEB_CLI_PDV PRIMARY KEY (CD_CTR,CD_EMP,CD_CLI)
ALTER TABLE RC_DEB_CLI_PDV ENABLE CHANGE_TRACKING;

END

GO
--DROP TABLE RC_DEB_CLI_PDV_PEND
IF	OBJECT_ID('RC_DEB_CLI_PDV_PEND') IS NULL
BEGIN
CREATE TABLE	RC_DEB_CLI_PDV_PEND
(
	CD_CTR	BIGINT	IDENTITY(1,1)	PRIMARY KEY,
	CD_EMP	INT	NOT NULL,
	CD_CLI	INT	NOT NULL,
	DT_PEND DATETIME DEFAULT GETDATE()
)

CREATE INDEX IX_RC_DEB_CLI_PDV_PEND ON RC_DEB_CLI_PDV_PEND(CD_EMP,CD_CLI) INCLUDE (CD_CTR,DT_PEND)

END

GO

IF	OBJECT_ID('TRG_RC_DEB_CLI_PDV_PEND') IS NOT NULL
BEGIN
	DROP TRIGGER TRG_RC_DEB_CLI_PDV_PEND;
END

GO

--DROP TRIGGER TRG_RC_DEB_CLI_PDV_PEND
--DISABLE TRIGGER [dbo].[TRG_RC_DEB_CLI_PDV_PEND] ON [dbo].[RC_DEB] 
CREATE TRIGGER [dbo].[TRG_RC_DEB_CLI_PDV_PEND] ON [dbo].[RC_DEB] AFTER INSERT,UPDATE,DELETE
AS
BEGIN
	--INSERTS E UPDATES 
	INSERT INTO RC_DEB_CLI_PDV_PEND
	(CD_EMP,CD_CLI)
	SELECT	CD_EMP,CD_CLI	FROM INSERTED I WHERE NOT EXISTS (SELECT CD_CLI FROM RC_DEB_CLI_PDV_PEND P WHERE P.CD_EMP = I.CD_EMP AND P.CD_CLI = I.CD_CLI) GROUP BY CD_EMP,CD_CLI
	--DELETEDS
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT INTO RC_DEB_CLI_PDV_PEND
		(CD_EMP,CD_CLI)
		SELECT	CD_EMP,CD_CLI	FROM DELETED D WHERE NOT EXISTS (SELECT CD_CLI FROM RC_DEB_CLI_PDV_PEND P WHERE P.CD_EMP = D.CD_EMP AND P.CD_CLI = D.CD_CLI) GROUP BY CD_EMP,CD_CLI
	END
END
